use super::{fields, ns};
use crate::options;
use lib_ruby_parser_nodes::NodeField;

/// Returns name of the node field getter for the given `node`/`field` pair
pub fn name(node_field: &NodeField) -> String {
    format!(
        "{ns}__{lower}__get_{field_name}",
        ns = ns(),
        lower = node_field.node.lower_name(),
        field_name = node_field.snakecase_name,
    )
}

/// Returns C signature of the node field getter for the given `node`/`field` pair
pub fn sig(node_field: &NodeField) -> String {
    format!(
        "{return_type} *{fn_attributes} {getter_name}({node_variant_blob} *self_blob)",
        return_type = fields::field_type(&node_field),
        fn_attributes = options().fn_attributes,
        getter_name = name(node_field),
        node_variant_blob = options().node_variant_blob_name(&node_field.node)
    )
}
