use crate::{options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__source_line", GLOBAL_NS)
}

pub fn source_line() -> String {
    format!(
        "
// SourceLine
{source_line_blob} {fn_attributes} {ns}__new(uint64_t start, uint64_t end, bool ends_with_eof);
void {fn_attributes} {ns}__drop({source_line_blob} *self_blob);
uint64_t {fn_attributes} {ns}__get_start(const {source_line_blob} *self_blob);
uint64_t {fn_attributes} {ns}__get_end(const {source_line_blob} *self_blob);
bool {fn_attributes} {ns}__get_ends_with_eof(const {source_line_blob} *self_blob);
void {fn_attributes} {ns}__set_start({source_line_blob} *self_blob, uint64_t start);
void {fn_attributes} {ns}__set_end({source_line_blob} *self_blob, uint64_t end);
void {fn_attributes} {ns}__set_ends_with_eof({source_line_blob} *self_blob, bool ends_with_eof);
",
        ns = ns(),
        fn_attributes = options().fn_attributes,
        source_line_blob = options().source_line_blob_name
    )
}
