use crate::{options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__maybe", GLOBAL_NS)
}

pub fn maybe() -> String {
    format!("
// Maybe<Loc>
{maybe_loc_blob} {fn_attributes} {ns}__loc__new_some({loc_blob} value);
{maybe_loc_blob} {fn_attributes} {ns}__loc__new_none();
void {fn_attributes} {ns}__loc__drop({maybe_loc_blob} *self_blob);
bool {fn_attributes} {ns}__loc__is_some(const {maybe_loc_blob} *self_blob);
bool {fn_attributes} {ns}__loc__is_none(const {maybe_loc_blob} *self_blob);
const {loc_blob} *{fn_attributes} {ns}__loc__as_value(const {maybe_loc_blob} *self_blob);
{loc_blob} {fn_attributes} {ns}__loc__into_value({maybe_loc_blob} self_blob);

// Maybe<Ptr<T>>
{maybe_ptr_blob} {fn_attributes} {ns}__ptr__new_some({ptr_blob} value);
{maybe_ptr_blob} {fn_attributes} {ns}__ptr__new_none();
void {fn_attributes} {ns}__ptr__of_node__drop({maybe_ptr_blob} *self_blob);
void {fn_attributes} {ns}__ptr__of_token__drop({maybe_ptr_blob} *self_blob);
bool {fn_attributes} {ns}__ptr__is_some(const {maybe_ptr_blob} *self_blob);
bool {fn_attributes} {ns}__ptr__is_none(const {maybe_ptr_blob} *self_blob);
const {ptr_blob} *{fn_attributes} {ns}__ptr__as_value(const {maybe_ptr_blob} *self_blob);
{ptr_blob} {fn_attributes} {ns}__ptr__into_value({maybe_ptr_blob} self_blob);

// Maybe<StringPtr>
{maybe_string_ptr_blob} {fn_attributes} {ns}__string_ptr__new_some({string_ptr_blob} value);
{maybe_string_ptr_blob} {fn_attributes} {ns}__string_ptr__new_none();
void {fn_attributes} {ns}__string_ptr__drop({maybe_string_ptr_blob} *self_blob);
bool {fn_attributes} {ns}__string_ptr__is_some(const {maybe_string_ptr_blob} *self_blob);
bool {fn_attributes} {ns}__string_ptr__is_none(const {maybe_string_ptr_blob} *self_blob);
const {string_ptr_blob} *{fn_attributes} {ns}__string_ptr__as_value(const {maybe_string_ptr_blob} *self_blob);
{string_ptr_blob} {fn_attributes} {ns}__string_ptr__into_value({maybe_string_ptr_blob} self_blob);

// Maybe<Decoder>
{maybe_decoder_blob} {fn_attributes} {ns}__decoder__new_some({decoder_blob} value);
{maybe_decoder_blob} {fn_attributes} {ns}__decoder__new_none();
void {fn_attributes} {ns}__decoder__drop({maybe_decoder_blob} *self_blob);
bool {fn_attributes} {ns}__decoder__is_some(const {maybe_decoder_blob} *self_blob);
bool {fn_attributes} {ns}__decoder__is_none(const {maybe_decoder_blob} *self_blob);
const {decoder_blob} *{fn_attributes} {ns}__decoder__as_value(const {maybe_decoder_blob} *self_blob);
{decoder_blob} {fn_attributes} {ns}__decoder__into_value({maybe_decoder_blob} self_blob);

// Maybe<TokenRewriter>
{maybe_token_rewriter_blob} {fn_attributes} {ns}__token_rewriter__new_some({token_rewriter_blob} value);
{maybe_token_rewriter_blob} {fn_attributes} {ns}__token_rewriter__new_none();
void {fn_attributes} {ns}__token_rewriter__drop({maybe_token_rewriter_blob} *self_blob);
bool {fn_attributes} {ns}__token_rewriter__is_some(const {maybe_token_rewriter_blob} *self_blob);
bool {fn_attributes} {ns}__token_rewriter__is_none(const {maybe_token_rewriter_blob} *self_blob);
const {token_rewriter_blob} *{fn_attributes} {ns}__token_rewriter__as_value(const {maybe_token_rewriter_blob} *self_blob);
{token_rewriter_blob} {fn_attributes} {ns}__token_rewriter__into_value({maybe_token_rewriter_blob} self_blob);
",
        ns = ns(),
        fn_attributes = options().fn_attributes,
        // loc
        loc_blob = options().loc_blob_name,
        maybe_loc_blob = options().maybe_loc_blob_name,
        // ptr
        ptr_blob = options().ptr_blob_name,
        maybe_ptr_blob = options().maybe_ptr_blob_name,
        // string_ptr
        string_ptr_blob = options().string_ptr_blob_name,
        maybe_string_ptr_blob = options().maybe_string_ptr_blob_name,
        // decoder
        decoder_blob = options().decoder_blob_name,
        maybe_decoder_blob = options().maybe_decoder_blob_name,
        // token_rewriter
        token_rewriter_blob = options().token_rewriter_blob_name,
        maybe_token_rewriter_blob = options().maybe_token_rewriter_blob_name
    )
}
