use crate::{options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__loc", GLOBAL_NS)
}

pub fn loc() -> String {
    format!(
        "
// Loc
{loc_blob} {fn_attributes} {ns}__new(uint64_t begin, uint64_t end);
void {fn_attributes} {ns}__drop({loc_blob} *self_blob);
uint64_t {fn_attributes} {ns}__get_begin(const {loc_blob} *self_blob);
uint64_t {fn_attributes} {ns}__get_end(const {loc_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options().fn_attributes,
        loc_blob = options().loc_blob_name
    )
}
