use super::ns;
use crate::Options;
use lib_ruby_parser_nodes::Node;

/// Returns name of the cast-to-variant fn for the given `node`
pub fn name(node: &Node) -> String {
    format!("{ns}__into_{lower}", ns = ns(), lower = node.lower_name())
}

/// Returns C signature of the cast-to-variant fn for the given `node`
pub fn sig(node: &Node, options: &Options) -> String {
    format!(
        "{node_variant_blob} {fn_name}({node_blob} blob)",
        node_variant_blob = options.node_variant_blob_name(node),
        fn_name = name(node),
        node_blob = options.node_blob_name
    )
}
