use super::{fields, ns};
use crate::Options;
use lib_ruby_parser_nodes::Message;

/// Returns name of the message constructor for the given `message`
pub fn name(message: &Message) -> String {
    format!(
        "{ns}__new_{variant}",
        ns = ns(),
        variant = message.lower_name()
    )
}

fn arglist(message: &Message, options: &Options) -> String {
    message
        .fields
        .map(&|field| {
            format!(
                "{field_type} {field_name}",
                field_type = fields::field_type(field, options),
                field_name = fields::field_name(field)
            )
        })
        .join(", ")
}

/// Returns C signature of the message constructor for the given `message`
pub fn sig(message: &Message, options: &Options) -> String {
    format!(
        "{diagnostic_message_blob} {constructor_name}({arglist})",
        diagnostic_message_blob = options.diagnostic_message_blob_name,
        constructor_name = name(message),
        arglist = arglist(message, options)
    )
}
