use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__token", GLOBAL_NS)
}

pub fn token(options: &Options) -> String {
    format!(
        "
// Token
{token_blob} {ns}__new(
    uint32_t token_type,
    {bytes_blob} token_value,
    {loc_blob} loc,
    uint32_t lex_state_before,
    uint32_t lex_state_after);
uint32_t {ns}__get_token_type(const {token_blob} *blob);
const {bytes_blob} *{ns}__get_token_value(const {token_blob} *blob);
void {ns}__set_token_value({token_blob} *blob, {bytes_blob} token_value_blob);
{bytes_blob} {ns}__into_token_value({token_blob} blob);
const {loc_blob} *{ns}__get_loc(const {token_blob} *blob);
uint32_t {ns}__get_lex_state_before(const {token_blob} *blob);
uint32_t {ns}__get_lex_state_after(const {token_blob} *blob);
void {ns}__drop({token_blob} *blob);",
        ns = ns(),
        token_blob = options.token_blob_name,
        bytes_blob = options.bytes_blob_name,
        loc_blob = options.loc_blob_name,
    )
}
