use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__shared_byte_list", GLOBAL_NS)
}

pub fn shared_byte_list(options: &Options) -> String {
    format!(
        "
// SharedByteList
{shared_byte_list_blob} {ns}__new(const uint8_t *ptr, uint64_t len);
const uint8_t *{ns}__get_raw(const {shared_byte_list_blob} *blob);
uint64_t {ns}__get_len(const {shared_byte_list_blob} *blob);",
        ns = ns(),
        shared_byte_list_blob = options.shared_byte_list_blob_name
    )
}
