use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__ptr", GLOBAL_NS)
}

pub fn ptr(options: &Options) -> String {
    format!(
        "
// Ptr
{ptr_blob} {ns}__new(void *ptr);
{ptr_blob} {ns}__new_null();
void *{ns}__get_raw({ptr_blob} *blob);
void {ns}__of_node__free({ptr_blob} *blob);
void {ns}__of_token__free({ptr_blob} *blob);",
        ns = ns(),
        ptr_blob = options.ptr_blob_name
    )
}
