use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__magic_comment_kind", GLOBAL_NS)
}

pub fn magic_comment_kind(options: &Options) -> String {
    format!(
        "
// MagicCommentKind
{magic_comment_kind_blob} {ns}__new_encoding();
{magic_comment_kind_blob} {ns}__new_frozen_string_literal();
{magic_comment_kind_blob} {ns}__new_warn_indent();
{magic_comment_kind_blob} {ns}__new_shareable_constant_value();

bool {ns}__is_encoding({magic_comment_kind_blob} blob);
bool {ns}__is_frozen_string_literal({magic_comment_kind_blob} blob);
bool {ns}__is_warn_indent({magic_comment_kind_blob} blob);
bool {ns}__is_shareable_constant_value({magic_comment_kind_blob} blob);",
        ns = ns(),
        magic_comment_kind_blob = options.magic_comment_kind_blob_name
    )
}
