use crate::{Options, NS as GLOBAL_NS};

pub fn list(options: &Options) -> String {
    vec![
        list_of(
            &options.byte_blob_name,
            &options.byte_list_blob_name,
            "of_bytes",
        ),
        list_of(
            &options.token_blob_name,
            &options.token_list_blob_name,
            "of_tokens",
        ),
        list_of(
            &options.node_blob_name,
            &options.node_list_blob_name,
            "of_nodes",
        ),
        list_of(
            &options.diagnostic_blob_name,
            &options.diagnostic_list_blob_name,
            "of_diagnostics",
        ),
        list_of(
            &options.comment_blob_name,
            &options.comment_list_blob_name,
            "of_comments",
        ),
        list_of(
            &options.magic_comment_blob_name,
            &options.magic_comment_list_blob_name,
            "of_magic_comments",
        ),
        list_of(
            &options.source_line_blob_name,
            &options.source_line_list_blob_name,
            "of_source_lines",
        ),
    ]
    .join("\n")
}

fn ns(subns: &str) -> String {
    format!("{}__list__{}", GLOBAL_NS, subns)
}

fn list_of(item_blob: &str, list_blob: &str, subns: &str) -> String {
    format!(
        "
// Vec<{item_blob}>
{list_blob} {ns}__new();
void {ns}__drop({list_blob} *blob);
{list_blob} {ns}__with_capacity(uint64_t capacity);
{list_blob} {ns}__from_raw({item_blob} *ptr, uint64_t len);
void {ns}__push({list_blob} *blob, {item_blob} item_blob);
{item_blob} {ns}__remove({list_blob} *blob, uint64_t index);
void {ns}__shrink_to_fit({list_blob} *blob);
{item_blob} *{ns}__as_ptr({list_blob} *blob);
uint64_t {ns}__len(const {list_blob} *blob);
uint64_t {ns}__capacity(const {list_blob} *blob);",
        ns = ns(subns),
        list_blob = list_blob,
        item_blob = item_blob
    )
}
