use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__error_level", GLOBAL_NS)
}

pub fn error_level(options: &Options) -> String {
    format!(
        "
// ErrorLevel
{error_level_blob} {ns}__new_warning();
{error_level_blob} {ns}__new_error();
bool {ns}__is_warning({error_level_blob} blob);
bool {ns}__is_error({error_level_blob} blob);",
        ns = ns(),
        error_level_blob = options.error_level_blob_name,
    )
}
