use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__bytes", GLOBAL_NS)
}

pub fn bytes(options: &Options) -> String {
    format!(
        "
// Bytes
{bytes_blob} {ns}__new_from_byte_list({byte_list_blob} list_blob);
void {ns}__drop({bytes_blob} *blob);
const {byte_list_blob} *{ns}__get_byte_list(const {bytes_blob} *blob);
void {ns}__set_byte_list({bytes_blob} *blob, {byte_list_blob} list_blob);
{byte_list_blob} {ns}__into_byte_list({bytes_blob} blob);
void {ns}__push({bytes_blob} *blob, {byte_blob} byte);",
        ns = ns(),
        bytes_blob = options.bytes_blob_name,
        byte_list_blob = options.byte_list_blob_name,
        byte_blob = options.byte_blob_name
    )
}
