use log::{debug, error, info, log, trace, warn};

fn main() {
    // If no logging implementation is selected, the facade falls back to a "noop" implementation
    // that ignores all log messages. The overhead in this case is very small - just an integer
    // load, comparison and jump.
    info!("Hello, world!");
    warn!("Hello, world!");

    // let _ = lg::init();
    let _ = lg::info::init();
    error!("Hello, world!");
    info!("Hello, world!");
    warn!("Hello, world!");
    // ignored since exceeding max level
    debug!("Hello, world!");
    trace!("Hello, world!");

    log!(log::Level::Error, "Hello, world!");
    log!(target: "alt_target", log::Level::Error, "Hello, world!");
}
