use log::{Level, Metadata, Record};

use log::{LevelFilter, SetLoggerError};

static LG: SimpleLogger = SimpleLogger;

pub struct SimpleLogger;

impl log::Log for SimpleLogger {
    fn enabled(&self, metadata: &Metadata) -> bool {
        metadata.level() <= Level::Info
    }

    fn log(&self, record: &Record) {
        if self.enabled(record.metadata()) {
            println!(
                "{:?}: {} - {} - {}",
                record.line(),
                record.level(),
                record.target(),
                record.args()
            );
        }
    }

    fn flush(&self) {}
}

pub fn init() -> Result<(), SetLoggerError> {
    log::set_logger(&LG).map(|()| log::set_max_level(LevelFilter::Info))
}

pub mod info {
    use log::{Level, Metadata, Record};

    use log::{LevelFilter, SetLoggerError};

    static LG: SimpleLogger = SimpleLogger;

    pub struct SimpleLogger;

    impl log::Log for SimpleLogger {
        fn enabled(&self, metadata: &Metadata) -> bool {
            metadata.level() == Level::Info
        }

        fn log(&self, record: &Record) {
            if self.enabled(record.metadata()) {
                eprintln!("[{}] {}", record.level(), record.args(),);
            }
        }

        fn flush(&self) {}
    }

    pub fn init() -> Result<(), SetLoggerError> {
        log::set_logger(&LG).map(|()| log::set_max_level(LevelFilter::Info))
    }
}
