use crate::{Kind, Token};

#[test]
fn properties() {
    let token: Token = Token::new(Kind::NonAscii, 1, 2);
    assert_eq!(token.kind(), Kind::NonAscii);
    assert_eq!(token.position(), 1);
    assert_eq!(token.length(), 2);
    assert_eq!(token.limit(), 3);
    assert_eq!(token.range(), 1..3);
    assert_eq!(token.value("hello"), "el");
}

#[test]
fn display() {
    let token: Token = Token::new(Kind::NonAscii, 1, 2);
    assert_eq!(token.to_string(), "kind=non-ascii pos=1 len=2")
}
