use crate::{Kind, Lex, Token};

#[test]
fn properties() {
    let source: &'static str = "the source";
    let tokens: Vec<Token> = vec![
        Token::new(Kind::Symbol, 0, 3),
        Token::new(Kind::Whitespace, 3, 1),
        Token::new(Kind::Symbol, 4, 6),
    ];
    let lex: Lex = Lex::new(source, tokens.clone());
    assert_eq!(lex.source(), source);
    assert_eq!(lex.tokens(), tokens);
}

#[test]
fn export_tokens() {
    let source: &'static str = "the source";
    let tokens: Vec<Token> = vec![
        Token::new(Kind::Symbol, 0, 3),
        Token::new(Kind::Whitespace, 3, 1),
        Token::new(Kind::Symbol, 4, 6),
    ];
    let lex: Lex = Lex::new(source, tokens.clone());
    assert_eq!(lex.export_tokens(), tokens);
}

#[test]
fn display() {
    let source: &'static str = "the \tsource\r\ncode";
    let tokens: Vec<Token> = vec![
        Token::new(Kind::Symbol, 0, 3),
        Token::new(Kind::Whitespace, 3, 2),
        Token::new(Kind::Symbol, 5, 6),
        Token::new(Kind::LineEnding, 11, 2),
        Token::new(Kind::Symbol, 13, 4),
    ];
    let lex: Lex = Lex::new(source, tokens.clone());
    let display: String = lex.to_string();
    let split: Vec<&str> = display.split("\n").collect();
    assert_eq!(split.len(), 8);
    assert_eq!(split[0], "line 0:");
    assert_eq!(split[1], "\t    0  symbol      :  the");
    assert_eq!(split[2], "\t    3  whitespace  :  st");
    assert_eq!(split[3], "\t    5  symbol      :  source");
    assert_eq!(split[4], "\t   11  line-ending :  rn");
    assert_eq!(split[5], "line 1:");
    assert_eq!(split[6], "\t    0  symbol      :  code");
    assert_eq!(split[7], "");
}
