use super::*;

#[derive(Serialize)]
#[serde(untagged)]
pub(crate) enum Operate<'a> {
    Create {
        data: Vec<serde_json::Value>,
    },
    Get {
        id: &'a str,
        fields: Vec<&'a str>,
    },
    Set {
        id: &'a str,
        data: serde_json::Value,
    },
    Query {
        conditions: conditions::Conditions<'a>,
    },
    UpdateByQuery {
        query: query::Query<'a>,
        data: serde_json::Value,
    },
}
