use serde_derive::Serialize;
use std::collections::HashMap;

mod builder;
mod conditions;
mod operate;
mod query;
mod aggregation;
mod clause;

pub use query::Query;
pub use aggregation::Aggs;

#[derive(Serialize)]
pub struct Request<'a> {
    auth: u8,
    project: &'a str,
    table: &'a str,

    #[serde(flatten)]
    operate: operate::Operate<'a>,
}

impl<'a> Request<'a> {
    pub fn project(project: &'a str) -> builder::Project<'a> {
        builder::Project { project }
    }
}

impl<'a> std::fmt::Display for Request<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        write!(f, "{}", serde_json::to_value(&self).unwrap())
    }
}
