use serde_derive::Serialize;
use std::collections::HashMap;

mod builder;
mod conditions;
mod operate;
mod query;

pub use query::Query;

#[derive(Serialize)]
pub struct Request<'p, 't, 'o1, 'o2> {
    auth: u8,
    project: &'p str,
    table: &'t str,

    #[serde(flatten)]
    operate: operate::Operate<'o1, 'o2>,
}

impl<'p, 't, 'o1, 'o2> Request<'p, 't, 'o1, 'o2> {
    pub fn project<'a: 'p>(project: &'a str) -> builder::Project<'p> {
        builder::Project { project }
    }
}

impl<'p, 't, 'o1, 'o2> std::fmt::Display for Request<'p, 't, 'o1, 'o2> {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        write!(f, "{}", serde_json::to_value(&self).unwrap())
    }
}
