use super::*;

#[derive(Serialize)]
#[serde(untagged)]
pub enum Operate<'a, 'b> {
    Create {
        data: Vec<serde_json::Value>,
    },
    Get {
        id: &'a str,
        fields: Vec<&'b str>,
    },
    Set {
        id: &'a str,
        data: serde_json::Value,
    },
    Query {
        conditions: conditions::Conditions<'a>,
    },
    UpdateByQuery {
        query: query::Query<'a>,
        data: serde_json::Value,
    },
}
