pub enum Error {
    ResponseErr(String),
    ResponseDeserializeErr(String),
}

impl std::fmt::Debug for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        write!(f, "Error: {self}")
    }
}

impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        let s = match self {
            Error::ResponseErr(e) => format!("response has error: {e}"),
            Error::ResponseDeserializeErr(e) => format!("response deserialize error: {e}"),
        };
        write!(f, "Error: {s}")
    }
}
