# Levitas Client
Author: qians
Date: 2022/5/1
WasmVersion: 1.0.0

## Request
### Create
```rust
let req = Request::project("project")
    .table("table")
    .create()
    .create_one(serde_json::json!({
        "t-name": "h",
        "t-age": 10
    }))
    .create_one(serde_json::json!({
        "t-name": "hhh",
        "t-age": 10
    }))
    .done()
    .to_string();

let reqj = serde_json::json!({
    "auth": 2,
    "project": "project",
    "table": "table",
    "data":[
        {
            "t-name": "h",
            "t-age": 10
        },
        {
            "t-name": "hhh",
            "t-age": 10
        }
    ]
})
.to_string();
assert_eq!(req, reqj)
```

### Get
```rust
let req = Request::project("project")
    .table("table")
    .get("2")
    .add_fields(&[String::from("t-name"), String::from("t-age")])
    .done()
    .to_string();

let reqj = serde_json::json!({
    "auth": 2,
    "project": "project",
    "table": "table",
    "fields": ["t-name", "t-age"],
    "id": "2"
})
.to_string();
assert_eq!(req, reqj)
```

### Set
```rust
let req = Request::project("project")
    .table("table")
    .set("2")
    .done(serde_json::json!({
        "t-name": "h",
        "t-age": 10
    }))
    .to_string();

let reqj = serde_json::json!({
    "auth": 2,
    "project": "project",
    "table": "table",
    "id": "2",
    "data": {
        "t-name": "h",
        "t-age": 10
    }
})
.to_string();
assert_eq!(req, reqj)
```

### Query
```rust
let req = Request::project("project")
    .table("table")
    .query(
        Query::new()
            .and()
            .gt("t-id", 1)
            .and()
            .query(Query::new().and().lt("t-id", 1).or().eq("t-id", "qians")),
    )
    .desc("t-id")
    .add_field("t-id")
    .add_field("t-name")
    .set_pagination(1, 4)
    .done()
    .to_string();

let reqj = serde_json::json!({
    "auth": 2,
    "project": "project",
    "table": "table",
    "conditions": {
        "pagination": {
            "page": 1,
            "pageSize": 4
        },
        "order": {
            "t-id": "desc"
        },
        "fields": ["t-id", "t-name"],
        "query": {
            "and": [
                {"range": {"t-id": {"gt": 1}}},
                {"query": {
                    "and": [
                        {"range": {"t-id": {"lt": 1}}}
                    ],
                    "or": [
                        {"match": {"t-id": "qians"}}
                    ]
                }}
            ]
        }
    }
})
.to_string();
assert_eq!(req, reqj);
```

### UpdateByQuery
```rust
let req = Request::project("project")
    .table("table")
    .update_by_query(Query::new().and().eq("id", "2"))
    .done(serde_json::json!({
        "t-name": "hhh",
        "t-age": 10
    }))
    .to_string();

let qv = serde_json::json!({
    "auth": 2,
    "project": "project",
    "table": "table",
    "query": {
        "and": [
            {"match": {"id": "2"}}
        ]
    },
    "data": {
        "t-name": "hhh",
        "t-age": 10
    }
})
.to_string();
assert_eq!(req, qv);
```


# Response
## handle response
```rust
#[derive(serde_derive::Deserialize, Clone, Debug, PartialEq, Eq)]
struct A {
    a: i32,
    b: String,
    c: bool,
    d: Option<String>,
}

let a = A {
    a: 1,
    b: String::from("1"),
    c: true,
    d: Some(String::from("1")),
};
let v = vec![a.clone(), a.clone(), a.clone()];

let json = serde_json::json!({
    "error": "",
    "count": 3,
    "data": [
        {
            "a": 1,
            "b": "1",
            "c": true,
            "d": "1",
        },
        {
            "a": 1,
            "b": "1",
            "c": true,
            "d": "1",
        },
        {
            "a": 1,
            "b": "1",
            "c": true,
            "d": "1",
        }
    ]
})
.to_string();
let res: Response = serde_json::from_str(&json).unwrap();
let res: Vec<A> = res.into().unwrap();

assert_eq!(v, res)
```
