#[doc = include_str!("../README.md")]

pub mod sequence;

pub use crate::sequence::builder::SequenceBuilder;
pub use sequence::renderer::SeqRendererBuilder;

#[derive(Debug, Eq, PartialEq)]
pub enum SequenceError {
	OutOfRange,

	// Used when converting from ordinal to character
	NotAsciiCharacter,

	// Used when converting from character to ordinal
	InvalidCharacter(char),

	InvalidString,
	EmptyString,
	PaddingAlpha,
}

const LETTERS: u64 = 25;
