# letter-sequence

Letter-Sequence is a crate that gives you the ability to create sequences more
complex then simple ordinal digits.

## Features

* Render-binding - limit a sequence by the rendered output
* Render a sequence in uppercase, lowercase, or as numeric.


An uppercase sequence, unbounded by rendering output
```rust
use letter_sequence::sequence::builder;
use std::convert::TryFrom;

let mut seq = builder::SequenceBuilder::try_from("A")
	.unwrap()
	.upper()
	.build()
	.unwrap();
assert_eq!( seq.to_string(), "A" );
seq.next();
assert_eq!( seq.to_string(), "B" );
seq.set(25).unwrap();
assert_eq!( seq.to_string(), "Z" );
seq.nth(3);
assert_eq!( seq.to_string(), "AD" );
```

This time with `.max_render_capacity()` set, and `.lower()` cased
```rust
use letter_sequence::sequence::builder;
use std::convert::From;
use std::convert::TryFrom;

let mut seq = builder::SequenceBuilder::try_from("y")
	.unwrap()
	.lower()
	.max_render_capacity(1)
	.build()
	.unwrap();
assert_eq!( seq.next().unwrap().to_string(), "z"  );
assert_eq!( seq.next(),                      None );
```

Also supports bounded and unbounded numeric sequences
```rust
use letter_sequence::sequence::builder;
use std::convert::From;
use std::convert::TryFrom;

let mut seq = builder::SequenceBuilder::new(99)
	.numeric()
	.max_render_capacity(3)
	.build()
	.unwrap();
assert_eq!( seq.to_string(),                 "99"  );
assert_eq!( seq.next().unwrap().to_string(), "100" );
```
