//! An uppercase sequence, unbounded by rendering output
//! ```rust
//! use letter_sequence::sequence::builder;
//! let mut seq = builder::SequenceBuilder::new(0)
//! 	.upper()
//! 	.build()
//! 	.unwrap();
//! assert_eq!( seq.to_string(), "A" );
//! seq.next();
//! assert_eq!( seq.to_string(), "B" );
//! seq.set(25).unwrap();
//! assert_eq!( seq.to_string(), "Z" );
//! seq.nth(3);
//! assert_eq!( seq.to_string(), "AD" );
//! ```
//!
//! This time with `.max_chars()` set, and `.lower()` cased
//! ```rust
//! use letter_sequence::sequence::builder;
//! let mut seq = builder::SequenceBuilder::new(24)
//! 	.lower()
//! 	.max_chars(1)
//! 	.build()
//! 	.unwrap();
//! assert_eq!( seq.to_string(),                 "y"  );
//! assert_eq!( seq.next().unwrap().to_string(), "z"  );
//! assert_eq!( seq.to_string(),                 "z"  );
//! assert_eq!( seq.next(),                      None );
//! ```
//! Also supports bounded and unbounded numeric sequences
//! ```rust
//! use letter_sequence::sequence::builder;
//! let mut seq = builder::SequenceBuilder::new(99)
//! 	.numeric()
//! 	.max_chars(3)
//! 	.build()
//! 	.unwrap();
//! assert_eq!( seq.to_string(),                 "99"  );
//! assert_eq!( seq.next().unwrap().to_string(), "100" );
//! ```

pub mod sequence;

#[derive(Debug, Eq, PartialEq)]
pub enum SequenceError {
	OutOfRange
}


const LETTERS: u64 = 25;
const A: u32  = 0;
const Z: u32 = 25;
