/*
 * Lethean VPN
 *
 * Distributed Virtual Private Marketplace
 *
 * The version of the OpenAPI document: 1.2.1
 * Contact: contact@lethean.io
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ServiceEntity {
    /// ID of the service
    #[serde(rename = "id")]
    pub id: String,
    /// Name of the service
    #[serde(rename = "name")]
    pub name: String,
    /// Type of the service
    #[serde(rename = "type")]
    pub _type: Type,
    /// Per minute Cost of the service
    #[serde(rename = "cost")]
    pub cost: String,
    /// Amount of pre-paid minutes for first payment
    #[serde(rename = "firstPrePaidMinutes", skip_serializing_if = "Option::is_none")]
    pub first_pre_paid_minutes: Option<f32>,
    /// Number of verifications needed for first payment
    #[serde(rename = "firstVerificationsNeeded", skip_serializing_if = "Option::is_none")]
    pub first_verifications_needed: Option<f32>,
    /// Amount of pre-paid minutes for subsequent payments
    #[serde(rename = "subsequentPrePaidMinutes", skip_serializing_if = "Option::is_none")]
    pub subsequent_pre_paid_minutes: Option<f32>,
    /// Number of verifications needed for subsequent payments
    #[serde(rename = "subsequentVerificationsNeeded", skip_serializing_if = "Option::is_none")]
    pub subsequent_verifications_needed: Option<f32>,
    /// Whether or not refunds are allowed
    #[serde(rename = "allowRefunds", skip_serializing_if = "Option::is_none")]
    pub allow_refunds: Option<bool>,
    /// Service download speed in Mbits
    #[serde(rename = "downloadSpeed")]
    pub download_speed: f32,
    /// Service upload speed in Mbits
    #[serde(rename = "uploadSpeed")]
    pub upload_speed: f32,
    /// array containing Proxy related settings. only available if service is of type proxy, null otherwise
    #[serde(rename = "proxy", skip_serializing_if = "Option::is_none")]
    pub proxy: Option<Vec<crate::models::ProxySettingsEntity>>,
    /// array containing VPN related settings. only available if service is of type vpn, null otherwise
    #[serde(rename = "vpn", skip_serializing_if = "Option::is_none")]
    pub vpn: Option<Vec<crate::models::VpnSettingsEntity>>,
    #[serde(rename = "validity", skip_serializing_if = "Option::is_none")]
    pub validity: Option<Box<crate::models::TimeRangeEntity>>,
    /// disable or not the service
    #[serde(rename = "disable")]
    pub disable: bool,
    /// inside each service, there should be a field named certificates that has a list of IDs, referencing the certificates at the provider level.
    #[serde(rename = "certificates", skip_serializing_if = "Option::is_none")]
    pub certificates: Option<Vec<crate::models::CertificatesEntity>>,
}

impl ServiceEntity {
    pub fn new(id: String, name: String, _type: Type, cost: String, download_speed: f32, upload_speed: f32, disable: bool) -> ServiceEntity {
        ServiceEntity {
            id,
            name,
            _type,
            cost,
            first_pre_paid_minutes: None,
            first_verifications_needed: None,
            subsequent_pre_paid_minutes: None,
            subsequent_verifications_needed: None,
            allow_refunds: None,
            download_speed,
            upload_speed,
            proxy: None,
            vpn: None,
            validity: None,
            disable,
            certificates: None,
        }
    }
}

/// Type of the service
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "vpn")]
    Vpn,
    #[serde(rename = "proxy")]
    Proxy,
}

