# \ExplorerApi

All URIs are relative to *https://dvpm.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_activity**](ExplorerApi.md#get_activity) | **GET** /v1/explorer/activity | 
[**get_block**](ExplorerApi.md#get_block) | **GET** /v1/explorer/chain/block/{id} | 
[**get_emission**](ExplorerApi.md#get_emission) | **GET** /v1/explorer/chain/emission | 
[**get_mempool**](ExplorerApi.md#get_mempool) | **GET** /v1/explorer/chain/mempool | 
[**get_network_info**](ExplorerApi.md#get_network_info) | **GET** /v1/explorer/chain/stats | 
[**get_outputs_blocks**](ExplorerApi.md#get_outputs_blocks) | **GET** /v1/explorer/chain/block/outputs | 
[**get_raw_block_data**](ExplorerApi.md#get_raw_block_data) | **GET** /v1/explorer/chain/block/raw/{id} | 
[**get_raw_transaction_data**](ExplorerApi.md#get_raw_transaction_data) | **GET** /v1/explorer/chain/transaction/raw/{tx_hash} | 
[**get_transaction**](ExplorerApi.md#get_transaction) | **GET** /v1/explorer/chain/transaction/{tx_hash} | 
[**get_transactions**](ExplorerApi.md#get_transactions) | **GET** /v1/explorer/chain/transactions | 
[**get_version**](ExplorerApi.md#get_version) | **GET** /v1/explorer/chain/version | 
[**prove_transfer**](ExplorerApi.md#prove_transfer) | **GET** /v1/explorer/validate/transfer | 
[**search_chain**](ExplorerApi.md#search_chain) | **GET** /v1/explorer/chain/search/{id} | 



## get_activity

> crate::models::Activity get_activity()


Project commits

### Parameters

This endpoint does not need any parameter.

### Return type

[**crate::models::Activity**](Activity.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_block

> crate::models::BlockDto get_block(id)


Get block data from block height

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**id** | **String** | Search id, must be block_number | [required] |

### Return type

[**crate::models::BlockDto**](BlockDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_emission

> crate::models::EmissionDto get_emission()


Blockchain emission stats

### Parameters

This endpoint does not need any parameter.

### Return type

[**crate::models::EmissionDto**](EmissionDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_mempool

> crate::models::MempoolDto get_mempool(limit, page)


Fetch transactions in memory pool

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**limit** | Option<**f32**> | Transactions per page |  |
**page** | Option<**f32**> | Page to show |  |

### Return type

[**crate::models::MempoolDto**](MempoolDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_network_info

> crate::models::NetworkStatsDto get_network_info()


Network stats for the chain

### Parameters

This endpoint does not need any parameter.

### Return type

[**crate::models::NetworkStatsDto**](NetworkStatsDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_outputs_blocks

> crate::models::BlockOutputsDto get_outputs_blocks(address, viewkey, limit, mempool)


Search for our outputs in last few blocks (up to 5 blocks), using provided address and viewkey.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**address** | **String** | Address to check | [required] |
**viewkey** | **String** | Viewkey for the transaction | [required] |
**limit** | Option<**f32**> | Blocks to check |  |
**mempool** | Option<**f32**> | Check mempool |  |

### Return type

[**crate::models::BlockOutputsDto**](BlockOutputsDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_raw_block_data

> crate::models::RawBlockDto get_raw_block_data(id)


Get raw chain data with the block ID

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**id** | **String** | Search id, must be block_number | [required] |

### Return type

[**crate::models::RawBlockDto**](RawBlockDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_raw_transaction_data

> crate::models::RawTransactionDto get_raw_transaction_data(tx_hash)


Get raw data from the chain about a transaction by its hash

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_hash** | **String** | Search id, must be tx_hash | [required] |

### Return type

[**crate::models::RawTransactionDto**](RawTransactionDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_transaction

> crate::models::TransactionDto get_transaction(tx_hash)


Fetch data about a transaction on the Blockhain

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_hash** | **String** | Transaction hash | [required] |

### Return type

[**crate::models::TransactionDto**](TransactionDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_transactions

> crate::models::TransactionsDto get_transactions(limit, page)


get the list of recent trasnactions

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**limit** | Option<**f32**> | Transactions per page |  |
**page** | Option<**f32**> | Page to show |  |

### Return type

[**crate::models::TransactionsDto**](TransactionsDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_version

> crate::models::VersionDto get_version()


Blockchain version

### Parameters

This endpoint does not need any parameter.

### Return type

[**crate::models::VersionDto**](VersionDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## prove_transfer

> crate::models::ProveTransferDto prove_transfer(txhash, address, viewkey, txprove)


### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**txhash** | **String** |  | [required] |
**address** | **String** |  | [required] |
**viewkey** | **f32** |  | [required] |
**txprove** | Option<**bool**> |  |  |

### Return type

[**crate::models::ProveTransferDto**](ProveTransferDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## search_chain

> crate::models::SearchDto search_chain(id)


Search the blockhain for records

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**id** | **String** | Search id, can be block_number | tx_hash | block_hash | [required] |

### Return type

[**crate::models::SearchDto**](SearchDTO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

