# Rust API client for lethean-api

Distributed Virtual Private Marketplace

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.1.1
- Package version: 1.1.1
- Build package: org.openapitools.codegen.languages.RustClientCodegen
For more information, please visit [https://lt.hn](https://lt.hn)

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *https://dvpm.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ExplorerApi* | [**get_block**](docs/ExplorerApi.md#get_block) | **GET** /v1/explorer/chain/block/{id} | 
*ExplorerApi* | [**get_emission**](docs/ExplorerApi.md#get_emission) | **GET** /v1/explorer/chain/emission | 
*ExplorerApi* | [**get_mempool**](docs/ExplorerApi.md#get_mempool) | **GET** /v1/explorer/chain/mempool | 
*ExplorerApi* | [**get_network_info**](docs/ExplorerApi.md#get_network_info) | **GET** /v1/explorer/chain/stats | 
*ExplorerApi* | [**get_outputs_blocks**](docs/ExplorerApi.md#get_outputs_blocks) | **GET** /v1/explorer/chain/block/outputs | 
*ExplorerApi* | [**get_raw_block_data**](docs/ExplorerApi.md#get_raw_block_data) | **GET** /v1/explorer/chain/block/raw/{id} | 
*ExplorerApi* | [**get_raw_transaction_data**](docs/ExplorerApi.md#get_raw_transaction_data) | **GET** /v1/explorer/chain/transaction/raw/{tx_hash} | 
*ExplorerApi* | [**get_transaction**](docs/ExplorerApi.md#get_transaction) | **GET** /v1/explorer/chain/transaction/{tx_hash} | 
*ExplorerApi* | [**get_transactions**](docs/ExplorerApi.md#get_transactions) | **GET** /v1/explorer/chain/transactions | 
*ExplorerApi* | [**get_version**](docs/ExplorerApi.md#get_version) | **GET** /v1/explorer/chain/version | 
*ExplorerApi* | [**prove_transfer**](docs/ExplorerApi.md#prove_transfer) | **GET** /v1/explorer/validate/transfer | 
*ExplorerApi* | [**search_chain**](docs/ExplorerApi.md#search_chain) | **GET** /v1/explorer/chain/search/{id} | 
*VpnApi* | [**list_services**](docs/VpnApi.md#list_services) | **GET** /v1/services/public-nodes | 


## Documentation For Models

 - [BlockDto](docs/BlockDto.md)
 - [BlockEntity](docs/BlockEntity.md)
 - [BlockOutputEntity](docs/BlockOutputEntity.md)
 - [BlockOutputsDto](docs/BlockOutputsDto.md)
 - [BlockOutputsEntity](docs/BlockOutputsEntity.md)
 - [CertificatesEntity](docs/CertificatesEntity.md)
 - [EcdhInfo](docs/EcdhInfo.md)
 - [EmissionDto](docs/EmissionDto.md)
 - [EmissionEntity](docs/EmissionEntity.md)
 - [InputsEntity](docs/InputsEntity.md)
 - [MempoolDto](docs/MempoolDto.md)
 - [MempoolEntity](docs/MempoolEntity.md)
 - [MgsEntity](docs/MgsEntity.md)
 - [MixinEntity](docs/MixinEntity.md)
 - [NetworkStatsDto](docs/NetworkStatsDto.md)
 - [NetworkStatsEntity](docs/NetworkStatsEntity.md)
 - [OutputEntity](docs/OutputEntity.md)
 - [ProveTransferDto](docs/ProveTransferDto.md)
 - [ProveTransferEntity](docs/ProveTransferEntity.md)
 - [ProveTransferOutputsEntity](docs/ProveTransferOutputsEntity.md)
 - [ProxySettingsEntity](docs/ProxySettingsEntity.md)
 - [RangeSigsEntity](docs/RangeSigsEntity.md)
 - [RawBlockDto](docs/RawBlockDto.md)
 - [RawBlockEntity](docs/RawBlockEntity.md)
 - [RawBlockMinerTx](docs/RawBlockMinerTx.md)
 - [RawBlockMinerVin](docs/RawBlockMinerVin.md)
 - [RawBlockMinerVinGen](docs/RawBlockMinerVinGen.md)
 - [RawBlockMinerVout](docs/RawBlockMinerVout.md)
 - [RawTransactionDto](docs/RawTransactionDto.md)
 - [RawTransactionEntity](docs/RawTransactionEntity.md)
 - [RawTransactionEntityVin](docs/RawTransactionEntityVin.md)
 - [RawTransactionEntityVinKey](docs/RawTransactionEntityVinKey.md)
 - [RawTransactionEntityVout](docs/RawTransactionEntityVout.md)
 - [RawTransactionEntityVoutTarget](docs/RawTransactionEntityVoutTarget.md)
 - [RawTransactionRctSignature](docs/RawTransactionRctSignature.md)
 - [RctSigEntity](docs/RctSigEntity.md)
 - [RctSigPrunable](docs/RctSigPrunable.md)
 - [SearchDto](docs/SearchDto.md)
 - [SearchEntity](docs/SearchEntity.md)
 - [ServiceEntity](docs/ServiceEntity.md)
 - [TimeRangeEntity](docs/TimeRangeEntity.md)
 - [TransactionBlock](docs/TransactionBlock.md)
 - [TransactionDto](docs/TransactionDto.md)
 - [TransactionEntity](docs/TransactionEntity.md)
 - [TransactionsDto](docs/TransactionsDto.md)
 - [TransactionsEntity](docs/TransactionsEntity.md)
 - [TxnEntity](docs/TxnEntity.md)
 - [VersionDto](docs/VersionDto.md)
 - [VersionEntity](docs/VersionEntity.md)
 - [VoutTarget](docs/VoutTarget.md)
 - [VpnSettingsEntity](docs/VpnSettingsEntity.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author

contact@lethean.io

