pub mod carriers;
pub mod constants;
pub mod records;
pub mod serializer;
pub mod tcp_worker;

#[cfg(test)]
mod tests {
    use crate::carriers::{CommonCarrier, RadioFlyer};
    use crate::constants::COMMON_PORTS;
    /*

    Conduct test scans banner grab tests

     */
    macro_rules! aw {
        ($e:expr) => {
            tokio_test::block_on($e)
        };
    }

    #[test]
    fn test_banner_grab() {
        let record = aw!(RadioFlyer::get_banner("example.com", 80));
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());
    }

    #[test]
    fn test_string_drop() {
        let record = aw!(RadioFlyer::string_drop(
            "example.com",
            "GET / HTTP/1.1\n\n",
            80
        ));
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());
    }

    #[test]
    fn test_host_drop() {
        let hosts = aw!(RadioFlyer::host_drop("example.com"));
        assert_eq!(hosts.is_ok(), true);
        let unwrapped = hosts.unwrap();
        assert_eq!(unwrapped.len() > 0, true)
    }
    #[test]
    fn test_scan_drop() {
        let ports: Vec<u16> = COMMON_PORTS.to_vec();
        let record = aw!(RadioFlyer::scan_drop("8.8.8.8", ports, 100));
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());
    }
    #[test]
    fn test_banner_drop() {
        let ports: Vec<u16> = COMMON_PORTS.to_vec();
        let record = aw!(RadioFlyer::banner_drop("example.com", ports, 100));
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());
    }
    #[test]
    fn test_scan_drops() {
        let ports: Vec<u16> = COMMON_PORTS.to_vec();
        let record = aw!(RadioFlyer::scan_drops(
            vec![
                "2001:4860:4860:0000:0000:0000:0000:8888",
                "8.8.8.8",
                "8.8.4.4",
                "example.com",
            ],
            ports,
            50,
        ));
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());
    }
    #[test]
    fn test_banner_drops() {
        let ports: Vec<u16> = COMMON_PORTS.to_vec();
        let record = aw!(RadioFlyer::banner_drops(
            vec![
                "2001:4860:4860:0000:0000:0000:0000:8888",
                "8.8.8.8",
                "8.8.4.4",
                "example.com",
            ],
            ports,
            50,
        ));
        assert_eq!(record.is_ok(), true);
        println!("{:?}", record.unwrap());
    }
    #[test]
    fn test_common_carrier_file() {
        let record = aw!(CommonCarrier::from_file("./assets/import_test.json"));
        assert_eq!(record.is_ok(), true);
        let unwrapped = record.unwrap();
        assert_eq!(unwrapped.len() == 5, true);
    }
}
