/**
Props:

host -> host of the port scan.

open_ports -> the ports that are open in the host.
*/
#[derive(Debug)]
pub struct BasicScanRecord {
    pub host: String,
    pub open_ports: Vec<i32>,
}

/**
Props:

host--> host where the banner was grabbed

port--> port where banner was grabbed

banner--> the banner in string format ready to be parsed.
*/
#[derive(Debug)]
pub struct BannerRecord {
    pub host: String,
    pub port: i32,
    pub banner: String,
}

/**
Props:

port--> port where banner was grabbed

banner--> the banner in string format ready to be parsed.

service--> service of parsed banner
 */
#[derive(Debug)]
pub struct ServiceRecord {
    pub port: i32,
    pub banner: String,
    pub service: ServiceEnum,
}

/**
Props:

port--> port where banner was grabbed

banner--> the banner in string format ready to be parsed.

service--> service of parsed banner
 */
#[derive(Debug)]
pub struct ServiceScanRecord {
    pub host: String,
    pub service_records: Vec<ServiceRecord>,
}

#[derive(Debug)]
pub enum ServiceEnum {
    FTP,
    SSH,
    TELNET,
    SMTP,
    DNS,
    HTTP,
    POP3,
    NNTP,
    NTP,
    IMAP,
    SNMP,
    IRC,
    HTTPS,
    SMTPS,
    CUPS,
    IMAPS,
    NIL,
}
