pub mod constants;
pub mod orchestrators;
pub mod records;
pub mod tcp_worker;

#[cfg(test)]
mod tests {
    use crate::constants::COMMON_PORTS;
    use crate::orchestrators::Conductor;
    /*

    Conduct test scans banner grab tests

     */
    #[test]
    fn test_banner_grab() {
        let banner = Conductor::conduct_banner_grab("example.com", 80);
        assert_eq!(banner.is_ok(), true);
    }

    #[test]
    fn test_send_string() {
        let banner = Conductor::conduct_send_string("8.8.8.8", "GET / HTTP/1.1\n\n", 80);
        assert_eq!(banner.is_ok(), true);
    }

    /*

    Conduct test scans

    */
    #[test]
    fn test_connect_scan() {
        let tcp_record = Conductor::conduct_connect_scan("example.com", vec![80, 443]);
        assert_eq!(tcp_record.is_ok(), true);
        let unwrapped = tcp_record.unwrap();
        assert_eq!(unwrapped.open_ports.len() > 0, true)
    }
    #[test]
    fn test_timeout_scan() {
        let tcp_record = Conductor::conduct_timeout_scan("example.com", vec![80, 443], 80);
        assert_eq!(tcp_record.is_ok(), true);
        let unwrapped = tcp_record.unwrap();
        assert_eq!(unwrapped.open_ports.len() > 0, true)
    }
    #[test]
    fn test_host_lookup() {
        let hosts = Conductor::conduct_host_lookup("example.com");
        assert_eq!(hosts.is_ok(), true);
        let unwrapped = hosts.unwrap();
        assert_eq!(unwrapped.len() > 0, true)
    }
    #[test]
    fn test_commonport_lookup() {
        let ports: Vec<i32> = COMMON_PORTS.to_vec();
        let ports = Conductor::conduct_timeout_scan("8.8.8.8", ports, 100);
        assert_eq!(ports.is_ok(), true);
    }

    #[test]
    fn test_service_scan() {
        let ports: Vec<i32> = COMMON_PORTS.to_vec();
        let services = Conductor::conduct_service_scan("alienvault.com", ports, 100);
        assert_eq!(services.is_ok(), true);
        println!("{:?}", services.unwrap());
    }
}
