use crate::records::ServiceEnum;
use std::collections::HashMap;

/**
#Common Ports
20 – FTP (File Transfer Protocol) Data Transfer

21 – FTP (File Transfer Protocol) Command Control

22 - SFTP (SSH File Transfer Protocol)

22 – SSH (Secure Shell)

23 - Telnet - Remote login service, unencrypted text messages

25 – SMTP (Simple Mail Transfer Protocol) E-mail Routing, Sending email

53 – DNS (domain name service)

80 – HTTP (Hypertext Transfer Protocol) used in World Wide Web. "web server"

110 – POP3 (Post Office Protocol) used by e-mail clients to retrieve e-mail from a server

119 - NNTP (Network News Transfer Protocol)

123 – NTP (Network Time Protocol)

143 – IMAP (Internet Message Access Protocol) Management of Digital Mail)

163 - SNMP (Simple Network Management Protocol)

194 - IRC (Internet Relay Chat)

443 – HTTPS (HTTP Secure (HTTPS) HTTP over TLS/SSL). "secure web server"

465 – SMTPS (send secure email)

631 – CUPS (print server)

993 – IMAPS (secure email inbox)

995 – POP3 (secure email inbox)
 */
pub const COMMON_PORTS: [i32; 18] = [
    20, 21, 22, 23, 25, 53, 80, 110, 119, 123, 143, 163, 194, 443, 465, 631, 993, 995,
];

pub struct ServiceMap {}

impl ServiceMap {
    pub fn get_service_map() -> HashMap<i32, ServiceEnum> {
        HashMap::from([
            (20, ServiceEnum::FTP),
            (21, ServiceEnum::FTP),
            (22, ServiceEnum::SSH),
            (23, ServiceEnum::TELNET),
            (25, ServiceEnum::SMTP),
            (53, ServiceEnum::DNS),
            (80, ServiceEnum::HTTP),
            (110, ServiceEnum::POP3),
            (119, ServiceEnum::NNTP),
            (123, ServiceEnum::NTP),
            (143, ServiceEnum::IMAP),
            (163, ServiceEnum::SNMP),
            (194, ServiceEnum::IRC),
            (443, ServiceEnum::HTTPS),
            (465, ServiceEnum::SMTPS),
            (631, ServiceEnum::CUPS),
            (995, ServiceEnum::IMAPS),
            (995, ServiceEnum::POP3),
        ])
    }
}
