# lemme_see
Port Scanner API

This is an API to use in "Pelican", a free and open source data gathering platform.
This is still in its initial commit stage so things will change.
This is the start of a project to bring recon and attack surface into an easier and more consumable using 
cyber security tools and search engine indexing for certain phrases


>main stuff
```rust
use lemme_see::{orchestrators::Conductor, tcp_worker::{Scnr, Grabber}};

fn main() {
    
    let banner = Conductor::conduct_banner_grab("example.com", 80);
    let reply_string = Conductor::conduct_send_string("example.com", "sup bro", 80);
    let timeout_record = Conductor::conduct_timeout_scan("example.com", vec![80], 80);
    let connect_record = Conductor::conduct_connect_scan("example.com", vec![80]);
    let hosts = Conductor::conduct_host_lookup("example.com");

    //prints BannerRecord
    println!("{:?}", banner);
    //prints BannerRecord
    println!("{:?}", reply_string);
    //prints TcpConnectRecord
    println!("{:?}", timeout_record);
    //prints TcpConnectRecord
    println!("{:?}", connect_record);
    //prints vec[string]
    println!("{:?}", hosts);

    let scnr_record = Scnr::connect_scan("8.8.8.8", vec![80]);
    //prints vec[i32]
    println!("{:?}", scnr_record);
    let scnr_record = Scnr::timeout_scan("8.8.8.8", vec![80],80);
    //prints vec[i32]
    println!("{:?}", scnr_record);

    let grabber_record = Grabber::banner_grab("8.8.8.8", 80, 80);
    //prints string
    println!("{:?}", grabber_record);
    let grabber_record = Grabber::send_string("8.8.8.8", 80, "msg", 80);
    //prints string
    println!("{:?}", grabber_record);

}


```
