# Lembaran

Modular pagination library.

Lembaran provides utilities for fetching paged responses:

- Build async stream for paged responses.
- Extract URL from HTTP link header.

## Examples

- [Fetch GitHub repositories using `Tokio` + `reqwest`](examples/reqwest.rs).
- [Fetch GitHub repositories using `async-std` + `Surf`](examples/surf.rs).

## Installation

```toml
lembaran = { version = "0.2.0", features = ["stream", "ext_http"] }
```

### Cargo Features

- `web_linking`, includes types to extract RFC 8288: Web Linking from HTTP header.
- `ext_http`, includes support for `http` crate types, enables `web_linking`.
- `ext_http-types`, includes support for `http-types` crate types, enables `web_linking`.
- `stream`, includes types for creating async stream for paged responses.

## License & Contribution

Licensed under either of

- Apache License, Version 2.0
  ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
- MIT license
  ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.
