#![deny(missing_debug_implementations, missing_docs, rust_2018_idioms)]

//! Modular pagination library.
//!
//! Lembaran provides utilities for fetching paged responses:
//! - [stream] module contains types to build async stream for paged response.
//! - [web_linking] module contains types to extract URL from HTTP link header.
//!
//! ## Features
//!
//! Lembaran lets you pick which utilities you need via Cargo feature.
//!
//! - `lembaran_web_linking`, includes types to extract RFC 8288: Web Linking from HTTP header.
//! - `http`, includes support for `http` crate types, enables `lembaran_web_linking`.
//! - `http-types`, includes support for `http-types` crate types, enables `lembaran_web_linking`.
//! - `stream`, includes types for creating async stream for paged responses.
//!

#[cfg(feature = "stream")]
pub mod stream;

#[cfg(feature = "lembaran_web_linking")]
pub mod web_linking;
