# Lembaran

Modular pagination library.

Lembaran provides utilities for fetching paged responses:

- Build async stream for paged responses.
- Extract URL from HTTP link header.

## Examples

- Fetch GitHub repositories using `Tokio` + `reqwest`. [[Link]](examples/reqwest.rs)
- Fetch GitHub repositories using `async-std` + `Surf`. [[Link]](examples/surf.rs)

## Installation

```toml
lembaran = { version = "0.1.0", features = ["stream", "http"] }
```

### Cargo Features

- `lembaran_web_linking`, includes types to extract RFC 8288: Web Linking from HTTP header.
- `http`, includes support for `http` crate types, enables `lembaran_web_linking`.
- `http-types`, includes support for `http-types` crate types, enables `lembaran_web_linking`.
- `stream`, includes types for creating async stream for paged responses.
