use std::io;

#[derive(Debug)]
enum Response {
    Absent,
    Present,
    Correct,
}

#[derive(Debug)]
struct History {
    word: Vec<char>,
    response: Vec<Response>,
}

fn guess(history: &Vec<History>) -> &'static str {
    // Implement your resolver!
    "count"
}

fn main() {
    let mut history: Vec<History> = Vec::new();
    let mut word = guess(&history);
    println!("{}", word);

    loop {
        let mut line = String::new();
        io::stdin()
            .read_line(&mut line)
            .expect("Failed to read line");
        eprintln!("line: {}", line);
        match line.as_str().trim() {
            "NOT_IN_WORD_LIST" => {
                panic!("You need to give another word")
            }
            _ => {
                let response: Vec<Response> = line
                    .trim()
                    .split(",")
                    .map(|res| match res {
                        "correct" => Response::Correct,
                        "present" => Response::Present,
                        "absent" => Response::Absent,
                        unknown => panic!("Unrecognized response: {:?}", unknown),
                    })
                    .collect();
                if response.iter().all(|r| matches!(r, Response::Correct)) {
                    eprintln!("win: {:?}", word);
                    break;
                }
                history.push(History {
                    word: word.chars().collect(),
                    response,
                });
                eprintln!("{:?}", &history);
                word = guess(&history);
                println!("{}", word);
            }
        }
    }
}
