/*
 * No: 2136
 * Title: Earliest Possible Day of Full Bloom
 */

use crate::Solution;

impl Solution {
    pub fn earliest_full_bloom(plant_time: Vec<i32>, grow_time: Vec<i32>) -> i32 {
        let mut res = 0;
        let mut flowers: Vec<(i32, i32)> =
            grow_time.into_iter().zip(plant_time.into_iter()).collect();
        flowers.sort_by_key(|k| k.0);

        for (grow, plant) in flowers {
            res = std::cmp::max(res, grow) + plant;
        }

        res
    }
}
