import {writable} from 'svelte/store';

const base_url = process.env.is_prod ? window.location.href : window.location.href.replace(':8080', ':8081');

// base_path is relative to /api, so for /api/accounts, you'd pass /accounts
export default function(base_path) {
	const store = writable([]);

	store.set_base_path = function(base_path) {
		this.base_url = base_url + 'api' + base_path;
	}
	store.set_base_path(base_path);

	store.request = async function(method, path, params = null) {
		store.update(data => {
			data.loading = true;
			return data;
		});

		const headers = {
			'Content-Type': 'application/json'
		};
		const body = params ? JSON.stringify(params) : undefined;

		const response = await fetch(this.base_url + path, {method, body, headers});

		if(!response.ok) {
			store.update(data => {
				data.loading = false;
				return data;
			});
		}
		return response;
	};

	store.get = (url) => store.request('GET', url, null);
	store.post = (url, params) => store.request('POST', url, params);

	store.read = async () => {
		const response = await store.get('');
		if(response.ok) {
			const json = await response.json();
			store.set(json);
		}
	};
	store.create = (params) => store.post('', params);

	return store;
};

