use actix_web::body::BoxBody;
use actix_web::http::StatusCode;
use actix_web::HttpResponse;
use actix_web::HttpResponseBuilder;
use actix_web::ResponseError;

#[derive(Debug, thiserror::Error)]
pub enum Error {
	#[error("Database error")]
	Database(#[from] sqlx::Error),
	#[error("Account {0} not found")]
	AccountNotFound(u32)
}

impl ResponseError for Error {
	fn status_code(&self) -> StatusCode {
		match self {
			Self::Database(_) => StatusCode::INTERNAL_SERVER_ERROR,
			Self::AccountNotFound(_) => StatusCode::NOT_FOUND
		}
	}

	fn error_response(&self) -> HttpResponse<BoxBody> {
		HttpResponseBuilder::new(self.status_code()).body(self.to_string())
	}
}

