use actix_web::web;
use actix_web::HttpResponse;

#[derive(rust_embed::RustEmbed)]
#[folder = "ui/public/"]
struct Asset;

fn handle_embedded_file(path: &str) -> HttpResponse {
	match Asset::get(path) {
		Some(content) => HttpResponse::Ok()
			.content_type(mime_guess::from_path(path).first_or_octet_stream().as_ref())
			.body(content.data.into_owned()),
		None => HttpResponse::NotFound().body("404 Not Found")
	}
}

pub async fn index() -> HttpResponse {
	handle_embedded_file("index.html")
}

pub async fn static_file(path: web::Path<String>) -> HttpResponse {
	handle_embedded_file(path.as_str())
}

