{{- define "ledgrr.name" -}}
	{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" -}}
{{- end -}}

{{- define "ledgrr.chart" -}}
	{{- .Chart.Name -}}
{{- end -}}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "ledgrr.fullname" -}}
	{{- if .Values.fullnameOverride -}}
		{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" -}}
	{{- else -}}
		{{- $name := default .Chart.Name .Values.nameOverride -}}
		{{- if (contains $name .Release.Name) -}}
			{{- .Release.Name | trunc 63 | trimSuffix "-" -}}
		{{- else -}}
			{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" -}}
		{{- end -}}
	{{- end -}}
{{- end -}}

{{- define "ledgrr.image" -}}
	{{- with .Values.image -}}
		{{- printf "%s/%s:%s" .registry .name (.tag | toString) -}}
	{{- end -}}
{{- end -}}

{{- define "ledgrr.archiver_image" -}}
	{{- with .Values.archiver.image -}}
		{{- printf "%s/%s:%s" .registry .name (.tag | toString) -}}
	{{- end -}}
{{- end -}}

{{- define "ledgrr.labels" -}}
app.kubernetes.io/name: {{ template "ledgrr.name" . }}
app.kubernetes.io/instance: {{ .Release.Name }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
helm.sh/chart: {{ template "ledgrr.chart" . }}
{{- if .Values.extraLabels -}}
{{- toYaml .Values.extraLabels -}}
{{- end -}}
{{- end -}}

