use npm_rs::NpmEnv;
use npm_rs::NodeEnv;

fn main() {
	match std::fs::metadata("ui/public/build/bundle.js") {
		Ok(_) => eprintln!("UI already built; skipping"),
		Err(e) if e.kind() == std::io::ErrorKind::NotFound => {
			let exit_status = NpmEnv::default()
				.with_node_env(&NodeEnv::from_cargo_profile().unwrap_or_default())
				.set_path("ui")
				.init_env()
				.install(None)
				.run("build")
				.exec()
				.unwrap();
			eprintln!("exit_status: {}", exit_status);
		},
		Err(e) => panic!("{}", e)
	}
}
