use crate::utils::date::date_time_str;
use std::fs::OpenOptions;
use std::io::Write;
use std::path::PathBuf;

pub fn app_dir() -> Option<PathBuf> {
    let home_dir = dirs::home_dir();
    match home_dir {
        Some(h) => {
            let dir = h.join(".learnwy");
            std::fs::create_dir_all(dir.clone());
            Some(dir)
        }
        _ => None,
    }
}

pub fn write_append_file(p: PathBuf, content: &[u8]) {
    let parent = p.parent().unwrap();
    std::fs::create_dir_all(parent);
    OpenOptions::new()
        .create(true)
        .write(true)
        .append(true)
        .open(p.clone())
        .unwrap()
        .write(content);
}

pub fn write_file(p: PathBuf, content: &[u8]) {
    let parent = p.parent().unwrap();
    std::fs::create_dir_all(parent);
    OpenOptions::new().create(true).write(true).open(p.clone()).unwrap().write(content);
}

pub fn write_append_date_time_file(sub: String, d_ext: String, content: &[u8]) -> Option<PathBuf> {
    match app_dir() {
        Some(h) => {
            let p = h.join(sub).join(date_time_str() + d_ext.as_str());
            if p.exists() {
                None
            } else {
                write_append_file(p.clone(), content);
                Some(p)
            }
        }
        None => None,
    }
}
