use chrono::Utc;

pub fn date_str() -> String {
    Utc::now().format("%Y_%m_%d").to_string()
}

pub fn date_time_str() -> String {
    Utc::now().format("%Y_%m_%d__%H_%M_%S").to_string()
}

pub fn time_str() -> String {
    Utc::now().format("%H_%M_%S").to_string()
}

// TODO: local is not true
pub fn date_native_local_str() -> String {
    Utc::now().naive_local().format("%Y_%m_%d").to_string()
}

pub fn date_time_native_local_str() -> String {
    Utc::now().format("%Y_%m_%d__%H_%M_%S").to_string()
}

pub fn time_native_local_str() -> String {
    Utc::now().naive_local().format("%H_%M_%S").to_string()
}

mod tests {
    use crate::utils::date::{
        date_native_local_str, date_str, date_time_native_local_str, date_time_str,
        time_native_local_str, time_str,
    };

    #[test]
    fn d() {
        println!("{}", date_str())
    }

    #[test]
    fn dt() {
        println!("{}", date_time_str())
    }

    #[test]
    fn t() {
        println!("{}", time_str())
    }

    #[test]
    fn dn() {
        println!("{}", date_native_local_str())
    }

    #[test]
    fn dtn() {
        println!("{}", date_time_native_local_str())
    }

    #[test]
    fn tn() {
        println!("{}", time_native_local_str())
    }
}
