use rand::Rng;

pub fn pick<T: Copy>(seed: &Vec<T>) -> T {
    let mut rng = rand::thread_rng();
    let index: usize = rng.gen_range( 0..seed.len());
    return seed[index];
}

pub fn join<T: ToString>(collect: &Vec<T>) -> String {
    let mut joined: String = String::new();
    for item in collect {
        joined += item.to_string().as_ref();
    }
    return joined;
}

mod tests {
    use crate::utils::collect::{join, pick};

    #[test]
    fn test_join() {
        let (from, to) = (vec![vec!['a', 'c'], vec!['1', '2']], vec!["ac", "12"]);
        for (index, f) in from.iter().enumerate() {
            assert_eq!(join(f), to[index]);
        }
    }
    #[test]
    fn test_pick() {
        let v = vec![1, 2, 3, 4];
        assert!(v.contains(&pick(&v)));
    }
}
