use super::command::Command;
use crate::cli::Cli;
use crate::config::Config;
use clap::{Parser};
use thiserror::Error;
use crate::utils::collect::{join, pick};
use crate::utils::date::date_str;
use std::fs::OpenOptions;
use std::io::Write;
use crate::utils::paths::app_dir;

#[derive(Parser, Debug)]
pub struct GenPwd {
    #[clap(long)]
    gen_pwd: Option<String>,
}

impl Command for GenPwd {
    type Error = Error;

    fn apply(self, _config: &Config) -> Result<(), Self::Error> {
        println!("{}", gen_pwd());
        Ok(())
    }
}


#[derive(Error, Debug)]
pub enum Error {
    #[error("{}", "no error")]
    NoError,
}


static PWD_SEED: &str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

fn gen_pwd() -> String {
    let pwd = join(&(0..32).map(|_| pick(&PWD_SEED.chars().collect())).collect::<Vec<char>>());
    let home_dir = dirs::home_dir();
    if let Some(h) = app_dir() {
        let dir = h.join("pwd");
        std::fs::create_dir_all(dir.clone()).unwrap();
        OpenOptions::new()
            .create(true)
            .write(true)
            .append(true)
            .open(dir.join(date_str() + ".pwd"))
            .unwrap()
            .write_all(format!("{}\n", pwd).as_bytes()).unwrap();
    }
    pwd
}

mod tests {
    use crate::commands::gen_pwd::gen_pwd;

    #[test]
    fn test_1() {
        let mut result: Vec<String> = vec![];
        for i in 0u64..2u64.pow(4) {
            result.push(gen_pwd());
        }
        println!("{}", result.join("\n"));
    }
}
