use crate::commands;
use crate::config::Config;
use clap::Parser;
use crate::commands::command::Command;

#[derive(clap::Parser, Debug)]
pub enum SubCommand {
    /// Print shell completions to stdout
    #[clap(name = "completions", bin_name = "completions")]
    Completions(commands::completions::Completions),

    /// generate password
    #[clap(name = "gen-pwd", bin_name = "gen-pwd")]
    GenPwd(commands::gen_pwd::GenPwd),
}

impl SubCommand {
    pub fn call(self, config: Config) {
        match self {
            Self::Completions(cmd) => cmd.call(config),
            Self::GenPwd(cmd) => cmd.call(config),
        }
    }
}


/// A fast and simple Node.js manager.
#[derive(clap::Parser, Debug)]
#[clap(name = "learnwy-bin-utils", version = env ! ("CARGO_PKG_VERSION"), bin_name = "learnwy-bin-utils")]
pub struct Cli {
    #[clap(flatten)]
    pub config: Config,
    #[clap(subcommand)]
    pub subcmd: SubCommand,
}


pub fn parse() -> Cli {
    Cli::parse()
}