![Rust](./doc/image/Logo2.jpg)

Curated collection of lists of useful resources to learn Rust together.

## Content

- [ General-purpose official resources ](#general-purpose-official-resources)
- [ General-purpose courses ](#general-purpose-courses)
- [ Domain-specific ](#domain-specific)
- [ Interactive courses on Rust with feedback ](#interactive-courses-on-rust-with-feedback)
- [ Development on Rust problems solved ](#development-on-rust-problems-solved)
- [ Get help with Rust ](#get-help-with-rust)
- [ Algorithmic problems and solutions in Rust ](#algorithmic-problems-and-solutions-in-rust)
- [ Other resources on Rust ](#other-resources-on-rust)
- [ Markers legend ](#markers-legend)

## General-purpose official resources

( _general_ ) ( _official_ )

- [ Rust by Example ](https://doc.rust-lang.org/rust-by-example/index.html) ( _reading_ )
- [ The Rust Programming Language ](https://doc.rust-lang.org/book/ch00-00-introduction.html) ( _reading_ ) ( _course_ )
- [ The Rust Programming Reference ](https://doc.rust-lang.org/book/ch00-00-introduction.html) ( _reading_ )
- [ Codebase Refference ](https://doc.rust-lang.org/std/index.html) ( _reading_ )
- [ Rust cookbook ](https://rust-lang-nursery.github.io/rust-cookbook/)( _reading_ )
- [ Rust playground ](https://play.rust-lang.org/) ( _interactive_ )

## General-purpose courses

( _general_ ) ( _course_ )

- [ Intro to Rust with Tensor ](https://www.youtube.com/playlist?list=PLJbE2Yu2zumDF6BX6_RdPisRVHgzV02NW) ( _video_ )
- [ Rust Tutorial with Doug Milford ](https://www.youtube.com/playlist?list=PLLqEtX6ql2EyPAZ1M2_C0GgVd4A-_L4_5) ( _video_ )
- [ The Rust Lang Book with Lets' Get Rusty ](https://www.youtube.com/playlist?list=PLai5B987bZ9CoVR-QEIN9foz4QCJ0H2Y8) ( _video_ )
- [ Rust Programming Tutorial with Dcode ](https://www.youtube.com/playlist?list=PLVvjrrRCBy2JSHf9tGxGKJ-bYAN_uDCUL) ( _video_ )
- [ Easy Rust with Mithradates/Dhghomon ](https://www.youtube.com/playlist?list=PLfllocyHVgsRwLkTAhG0E-2QxCf-ozBkk) ( _video_ )
- [ Easy Rust with Mithradates/Dhghomon ](https://github.com/Dhghomon/easy_rust)  ( _reading_ )
- [ Программирование на Rust with Computer Science Center ](https://www.youtube.com/playlist?list=PLlb7e2G7aSpTfhiECYNI2EZ1uAluUqE_e) ( _video_ ) ( _non-english_ )
- [ Rust with Tutorials Point ](https://www.tutorialspoint.com/rust/index.htm) ( _reading_ )
- [ Rust with RIP Tutorial ](https://riptutorial.com/rust) ( _reading_ )

## Domain-specific

( _specific_ )

- [ Web development with rust with Genus-v ](https://www.youtube.com/playlist?list=PLECOtlti4Psr4hXVX5GuSvLKp0-RZjz93) ( _video_ ) ( _course_ )
- [ Yew Crash Course with Jeff No Zhao ](https://www.youtube.com/watch?v=lmLiMozWNGA) ( _video_ ) ( _article_ )

## Interactive courses on Rust with feedback

( _interactive_ )

- [ Rustlings ](https://github.com/rust-lang/rustlings)
- [ Rust with Exercism ](https://exercism.io/my/tracks/rust)

## Development on Rust problems solved

( _article_ )

- [ How to install debugger on Windows ](https://www.youtube.com/watch?v=f6tizikEMTk) ( _video_ )
- [ How to install debugger on Linux ](https://www.youtube.com/watch?v=rarFePIdNoc) ( _video_ )
- [ How to optimize sizeo of binary executable ](https://github.com/johnthagen/min-sized-rust) ( _reading_ )
- [ How to optimize sizeo of binary executable ](https://users.rust-lang.org/t/size-of-the-executable-binary-file-of-an-application/62160/7) ( _reading_ )
- [ How to optimize sizeo of WebAssembly binary executable ](http://cliffle.com/blog/bare-metal-wasm/#help-i-need-trig-importing-functions-from-javascript) ( _reading_ )

## Get help with Rust

( _forum_ )

- [Ask question on Rust Forum](https://users.rust-lang.org)
- [Ask question on Stack overflow](https://stackoverflow.com/)

## Algorithmic problems and solutions in Rust

( _algo_ )
- [ Rust Gym ](https://github.com/warycat/rustgym)

## Other resources on Rust

- [Safety in Systems Programming with Stanford University](https://web.stanford.edu/class/cs110l/) ( _reading_ ) ( _course_ )
- [Comp Sci Rust Programming Course from University of Pennsylvania's](http://cis198-2016s.github.io/schedule/) ( _reading_ ) ( _course_ )
- [Build a language VM with Fletcher Haynes](https://blog.subnetzero.io/post/building-language-vm-part-00/) ( _reading_ ) ( _course_ )
- [Refactoring to Rust with Lily Mara](https://livebook.manning.com/book/refactoring-to-rust/chapter-1/v-2/) ( _reading_ ) ( _course_ )

## Other collection and lists on Rust

( _list_ )

- [Game Engines and Renderers](./GameEnginesAndRenderers.md)
- [Our secondary collection of lists](./Secondary.md)
- [A curated list of Rust code and resources with Dunham](https://github.com/rust-unofficial/awesome-rust)
- [Rust Books with Sger](https://github.com/sger/RustBooks)

## Markers legend

- ( _general_ ) -- general-purpose material
- ( _specific_ ) -- domain-specific material
- ( _official_ ) -- official Rust material
- ( _non-english_ ) -- non-english language
- ( _course_ ) -- long course or a book
- ( _article_ ) -- either single article or single video-tutorial
- ( _not-finished_ ) -- not finished, too little to learn
- ( _interactive_ ) -- it is possible to interact and get feedback from the system
- ( _reading_ ) -- material to read
- ( _video_ ) -- material to watch
- ( _list_ ) -- list of resources
- ( _project_ ) -- a project
- ( _forum_ ) -- either chat or forum to comminicate with people
- ( _algo_ ) -- algorithmic problems and solutions
